
MEMORY {

//  2M Internal Flash - 1M Assigned to Z0
    int_flash	: org = 0x00100000, len = 1M

//  96K Internal SRAM Assigned to Z0
    sram    	: org = 0x40080000, len = 80k-1k

}

DEFAULTS {

    heap_reserve = 1k
    stack_reserve = 1K

}

// Program layout for starting in ROM, copying data to RAM,
// and continuing to execute out of ROM.



SECTIONS
{	

//
// RAM SECTIONS
//
    .PPC.EMB.sdata0 	          		    ABS : > sram
    .PPC.EMB.sbss0                            CLEAR ABS : > .
   
    .sdabase 		       		       ALIGN(16): > sram	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 						: > .
    .heap                  ALIGN(16) PAD(heap_reserve)  : > .   
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

//
// ROM SECTIONS
//

    .text						: > int_flash
    .vletext						: > .
    .syscall						: > .

    .rodata		 				: > .
    .sdata2 						: > .

    .secinfo 						: > .
    .fixaddr 						: > .
    .fixtype 						: > .

    .CROM.PPC.EMB.sdata0 	  CROM(.PPC.EMB.sdata0) : > .
    .CROM.sdata  	            	   CROM(.sdata) : > .
    .CROM.data 	            		    CROM(.data) : > .

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(sram);
    __ghs_ramend    = MEMENDADDR(sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);

//
// These special symbols mark the bounds of RAM and ROM images of boot code.
// They are used by the GHS startup code (_start and __ghs_ind_crt0).
//
    __ghs_rambootcodestart  = 0;
    __ghs_rambootcodeend    = 0;
    __ghs_rombootcodestart  = ADDR(.text);
    __ghs_rombootcodeend    = ENDADDR(.fixtype);
}

